//******************************************
//           This is a C Template file
//ߣ   
//     
//
//ע
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |16.VDD
02.P00/XIN.............02|               |15.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-16    |14.P41/AIN1/KWI1
04.P10/RESETB..........04|               |13.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |12.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-16   |11.P74/DVOB/AIN8/SI/KWI13      
07.P91/RX/TX...........07|               |10.P76/INT3/SCLK/KWI15
08.P72/TCA0/PPGA0B.....08|	             |9.P70/TC00/PWM00B               
.........................-----------------............................
*********************************************************************/
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "iApp.h"

//-- ض庯 --//


//-- ȫֱ --//


void PWM01_COMP_SEL_init(uint T1, uint T2, uint T3, uint T4);
void PWM01_COMP_adj(uint T1, uint T2, uint T3, uint T4);


//-- ȫֳ --//



void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨 ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Ҫ (ⲿپ or ⲿپ),  <OPmode.h> 趨£
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#undef	XTAL_Low		// ⲿپ: #define(ʹþ) / #undef(þ) :
//.....................................................................................
//	 <OPmode.h> ęnϳ
//	עļ֮ⲿл.
//--------------------------------------------------------------------------------------------------//




	P9DR.byte = 0x00;
	P9CR.byte = 0xff;


	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
__asm("CPL (_P7DR).0");
__asm("CPL (_P7DR).0");
__asm("CPL (_P7DR).1");
__asm("CPL (_P7DR).1");



	WDCDR.byte = 0x4e;				// clear wdt
__asm("CPL (_P7DR).4");
__asm("CPL (_P7DR).4");
__asm("CPL (_P7DR).6");
__asm("CPL (_P7DR).6");
__asm("CPL (_P9DR).0");
__asm("CPL (_P9DR).0");
__asm("CPL (_P9DR).1");
__asm("CPL (_P9DR).1");



	PWM01_COMP_SEL_init( 300,  500,  800, 1001);		// t1<t2<t3<t4 : (1~1023)
	delay_times(t_1ms, 100);


	PWM01_COMP_adj(      200,  600,  900, 1023);		// t1<t2<t3<t4 : (1~1023)
	delay_times(t_1ms, 100);

//for( iloop=10; iloop<24; iloop++ )
//{
//	PWM01_COMP_adj( 200,  600,  800, 1000+iloop);
//	look_data(iloop);
//	delay_times(t_1ms, 100);
//}
//---------------------------------------
//---------------------------------------
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
	}

}



//*********************************************************************
// 	: PWM01_COMP_SEL_init()
// 	: PWM0xB: 10λģʽ
// ע		:
//************************************
//	10λʾͼ
//************************************
//             _ _ _ _ _ _                         _ _ _ _ _ _
//            |           |                       |           |
//PWM00B   _ _|           |_ _ _ _ _ _ _ _ _ _ _ _|           |_ _ _ _ _ _ _ _ _ _ _ _
//                             _ _ _ _ _ _ _                       _ _ _ _ _ _ _
//                            |             |                     |             |
//PWM01B   _ _ _ _ _ _ _ _ _ _|             |_ _ _ _ _ _ _ _ _ _ _|             |_ _ _
//
//            ^           ^   ^             ^    ^
//            ^           ^   ^             ^    ^
//            ^           ^   ^             ^    ^
//            ^           ^   ^             ^    ^
//----------------------------------------------------------------------------------------
//            S           T   T             T    T
//            t           1   2             3    4
//            a                                  |
//            r<<----------- Cycle ------------>>|
//            t                                  |
//*********************************************************************
void PWM01_COMP_SEL_init(uint T1, uint T2, uint T3, uint T4)
{
	__asm("DI");
	POFFCR0.byte  = 0x10;
	// interrupt request setting
	ILH.bit.b4    = 0;
	ILH.bit.b5    = 0;
	EIRH.bit.b4   = 1;
	EIRH.bit.b5   = 1;
	// interrupt request setting
	__asm("EI");

	T00MOD.byte   = 0xEA;			// TFF0 = 1
	T01MOD.byte   = 0x7A;			// TFF1 = 0
	P7FC.byte     = 0x03;			// setting PxFC after TFFx

	T00REGL.byte  = (T4%0x0100);	// T4: totoal cycle
	T00REGH.byte  = (T4/0x0100);	// T4: totoal cycle
	T00PWML.byte  = (T1%0x0100);	// T1: 1st falling edge
	T00PWMH.byte  = (T1/0x0100);	// T1: 1st falling edge

	T01REGL.byte  = (T3%0x0100);	// T3: 3rd falling edge
	T01REGH.byte  = (T3/0x0100);	// T3: 3rd falling edge
	T01PWML.byte  = (T2%0x0100);	// T2: 2nd rising edge
	T01PWMH.byte  = (T2/0x0100);	// T2: 2nd rising edge

	T001CR.byte   = 0x13;			// start PPG00B/PPG01B
}


//*********************************************************************
// 	: PWM01_COMP_adj()
// 	: PWM0xB: 10λ޸
// ע		:
//*********************************************************************
void PWM01_COMP_adj(uint T1, uint T2, uint T3, uint T4)
{
	T00REGL.byte  = (T4%0x0100);	// T4: totoal cycle
	T00REGH.byte  = (T4/0x0100);	// T4: totoal cycle
	T00PWML.byte  = (T1%0x0100);	// T1: 1st falling edge
	T00PWMH.byte  = (T1/0x0100);	// T1: 1st falling edge

	T01REGL.byte  = (T3%0x0100);	// T3: 3rd falling edge
	T01REGH.byte  = (T3/0x0100);	// T3: 3rd falling edge
	T01PWML.byte  = (T2%0x0100);	// T2: 2nd rising edge
	T01PWMH.byte  = (T2/0x0100);	// T2: 2nd rising edge
}

